<?php
/**
 * Uninstall CodeGrinders Auto Poster AI
 *
 * @package CodeGrindersAutoPosterAI
 */

// If uninstall not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete plugin options
delete_option('cgap_settings');
delete_option('cgap_knowledge_base');

// Drop custom tables
global $wpdb;

$table_name = $wpdb->prefix . 'cgap_auto_posts';
$wpdb->query("DROP TABLE IF EXISTS $table_name");

// Clear scheduled cron jobs
wp_clear_scheduled_hook('cgap_daily_check');

// Remove any transients
delete_transient('cgap_license_status');
delete_transient('cgap_api_test');

// Clean up any uploaded files (if any were stored)
$upload_dir = wp_upload_dir();
$auto_poster_dir = $upload_dir['basedir'] . '/auto-poster/';

if (is_dir($auto_poster_dir)) {
    // Remove all files in the auto-poster directory
    $files = glob($auto_poster_dir . '*');
    foreach ($files as $file) {
        if (is_file($file)) {
            unlink($file);
        }
    }
    // Remove the directory itself
    rmdir($auto_poster_dir);
}

// Log uninstall for debugging (optional)
if (defined('WP_DEBUG') && WP_DEBUG) {
    error_log('CodeGrinders Auto Poster plugin uninstalled successfully');
}
?>

