<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap cgap-settings">
    <div class="cgap-header">
        <h1><i class="dashicons dashicons-admin-settings"></i> Auto Poster AI Settings</h1>
        <p class="cgap-subtitle">Configure your auto-posting preferences and AI settings</p>
    </div>

    <div class="cgap-settings-container">
        <div class="cgap-left-panel">
            <div class="cgap-card">
                <h2><i class="dashicons dashicons-admin-users"></i> License Management</h2>
                
                <div class="cgap-form-group">
                    <label for="license-key">License Key</label>
                    <input type="text" id="license-key" value="<?php echo esc_attr($settings['license_key'] ?? ''); ?>" placeholder="Enter your license key">
                    <p class="description">Enter your premium license key to unlock unlimited features.</p>
                </div>
                
                <div class="cgap-license-status">
                    <span class="status-label">Status:</span>
                    <span class="status-value <?php echo ($settings['license_status'] ?? 'inactive') === 'active' ? 'active' : 'inactive'; ?>">
                        <?php echo ($settings['license_status'] ?? 'inactive') === 'active' ? 'Active' : 'Inactive'; ?>
                    </span>
                </div>
                
                <?php if (($settings['license_status'] ?? 'inactive') === 'active'): ?>
                <div class="cgap-license-details">
                    <div class="license-detail">
                        <span class="detail-label">User Email:</span>
                        <span class="detail-value"><?php echo esc_html($settings['license_user_email'] ?? 'N/A'); ?></span>
                    </div>
                    <div class="license-detail">
                        <span class="detail-label">Issued:</span>
                        <span class="detail-value"><?php echo $settings['license_issued_at'] ? date('M j, Y', strtotime($settings['license_issued_at'])) : 'N/A'; ?></span>
                    </div>
                    <?php if (!empty($settings['license_expires_at'])): ?>
                    <div class="license-detail">
                        <span class="detail-label">Expires:</span>
                        <span class="detail-value"><?php echo date('M j, Y', strtotime($settings['license_expires_at'])); ?></span>
                    </div>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
                
                <button type="button" class="cgap-btn cgap-btn-primary" id="validate-license-btn">
                    <i class="dashicons dashicons-yes"></i>
                    Validate License
                </button>
                
                <button type="button" class="cgap-btn cgap-btn-secondary" id="check-license-btn">
                    <i class="dashicons dashicons-admin-tools"></i>
                    Check License Status
                </button>
            </div>

            <div class="cgap-card">
                <h2><i class="dashicons dashicons-admin-generic"></i> AI Configuration</h2>
                
                <div class="cgap-form-group">
                    <label for="ai-api-key">OpenAI API Key</label>
                    <input type="password" id="ai-api-key" value="<?php echo esc_attr($settings['ai_api_key'] ?? ''); ?>" placeholder="sk-...">
                    <p class="description">Your OpenAI API key for content generation. <a href="https://platform.openai.com/api-keys" target="_blank">Get your API key</a></p>
                </div>
                
                <div class="cgap-form-group">
                    <label for="ai-model">AI Model</label>
                    <select id="ai-model">
                        <option value="gpt-3.5-turbo" <?php selected($settings['ai_model'] ?? 'gpt-3.5-turbo', 'gpt-3.5-turbo'); ?>>GPT-3.5 Turbo (Fast & Cost-effective)</option>
                        <option value="gpt-4" <?php selected($settings['ai_model'] ?? 'gpt-3.5-turbo', 'gpt-4'); ?>>GPT-4 (High Quality)</option>
                        <option value="gpt-4-turbo" <?php selected($settings['ai_model'] ?? 'gpt-3.5-turbo', 'gpt-4-turbo'); ?>>GPT-4 Turbo (Latest)</option>
                    </select>
                </div>
            </div>

            <div class="cgap-card">
                <h2><i class="dashicons dashicons-admin-post"></i> Posting Configuration</h2>
                
                <div class="cgap-form-group">
                    <label for="keywords">Default Keywords</label>
                    <textarea id="keywords" rows="3" placeholder="Enter default keywords for auto-posting (e.g., 'artificial intelligence, machine learning, technology trends')"><?php echo esc_textarea($settings['keywords'] ?? ''); ?></textarea>
                    <p class="description">Keywords that will be used for automatic post generation.</p>
                </div>
                
                <div class="cgap-form-group">
                    <label for="post-frequency">Posting Frequency</label>
                    <select id="post-frequency">
                        <option value="daily" <?php selected($settings['post_frequency'] ?? 'weekly', 'daily'); ?>>Daily</option>
                        <option value="weekly" <?php selected($settings['post_frequency'] ?? 'weekly', 'weekly'); ?>>Weekly</option>
                        <option value="monthly" <?php selected($settings['post_frequency'] ?? 'weekly', 'monthly'); ?>>Monthly</option>
                    </select>
                </div>
                
                <div class="cgap-form-group">
                    <label for="post-status">Post Status</label>
                    <select id="post-status">
                        <option value="draft" <?php selected($settings['post_status'] ?? 'draft', 'draft'); ?>>Draft</option>
                        <option value="publish" <?php selected($settings['post_status'] ?? 'draft', 'publish'); ?>>Published</option>
                        <option value="private" <?php selected($settings['post_status'] ?? 'draft', 'private'); ?>>Private</option>
                    </select>
                </div>
                
                <div class="cgap-form-group">
                    <label for="post-category">Default Category</label>
                    <select id="post-category">
                        <option value="">Select Category</option>
                        <?php
                        $categories = get_categories(array('hide_empty' => false));
                        foreach ($categories as $category):
                        ?>
                        <option value="<?php echo $category->term_id; ?>" <?php selected($settings['post_category'] ?? '', $category->term_id); ?>>
                            <?php echo esc_html($category->name); ?>
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="cgap-form-group">
                    <label for="post-tags">Default Tags</label>
                    <input type="text" id="post-tags" value="<?php echo esc_attr($settings['post_tags'] ?? ''); ?>" placeholder="tag1, tag2, tag3">
                    <p class="description">Comma-separated tags to be added to generated posts.</p>
                </div>
            </div>
        </div>

        <div class="cgap-right-panel">
            <div class="cgap-card">
                <h2><i class="dashicons dashicons-format-image"></i> Image Generation</h2>
                
                <div class="cgap-form-group">
                    <label>
                        <input type="checkbox" id="generate-images" <?php checked($settings['generate_images'] ?? false); ?>>
                        Generate featured images automatically
                    </label>
                    <p class="description">Premium feature: Automatically generate AI images for posts.</p>
                </div>
                
                <div class="cgap-form-group">
                    <label for="image-style">Default Image Style</label>
                    <select id="image-style">
                        <option value="realistic" <?php selected($settings['image_style'] ?? 'realistic', 'realistic'); ?>>Realistic</option>
                        <option value="artistic" <?php selected($settings['image_style'] ?? 'realistic', 'artistic'); ?>>Artistic</option>
                        <option value="cartoon" <?php selected($settings['image_style'] ?? 'realistic', 'cartoon'); ?>>Cartoon</option>
                        <option value="abstract" <?php selected($settings['image_style'] ?? 'realistic', 'abstract'); ?>>Abstract</option>
                    </select>
                </div>
            </div>

            <div class="cgap-card">
                <h2><i class="dashicons dashicons-admin-generic"></i> Auto-Posting Control</h2>
                
                <div class="cgap-form-group">
                    <label>
                        <input type="checkbox" id="is-enabled" <?php checked($settings['is_enabled'] ?? false); ?>>
                        Enable automatic posting
                    </label>
                    <p class="description">When enabled, posts will be generated automatically based on your frequency settings.</p>
                </div>
                
                <div class="cgap-auto-posting-info">
                    <h4>Auto-Posting Schedule</h4>
                    <ul>
                        <li><strong>Free Version:</strong> 1 post per week maximum</li>
                        <li><strong>Premium Version:</strong> Unlimited posts based on your frequency setting</li>
                        <li><strong>Next Check:</strong> <?php echo wp_next_scheduled('cgap_daily_check') ? date('Y-m-d H:i:s', wp_next_scheduled('cgap_daily_check')) : 'Not scheduled'; ?></li>
                    </ul>
                </div>
            </div>

            <div class="cgap-card">
                <h2><i class="dashicons dashicons-admin-tools"></i> Actions</h2>
                
                <div class="cgap-actions">
                    <button type="button" class="cgap-btn cgap-btn-primary" id="save-settings-btn">
                        <i class="dashicons dashicons-yes"></i>
                        Save Settings
                    </button>
                    
                    <button type="button" class="cgap-btn cgap-btn-secondary" id="test-connection-btn">
                        <i class="dashicons dashicons-admin-tools"></i>
                        Test AI Connection
                    </button>
                    
                    <button type="button" class="cgap-btn cgap-btn-secondary" id="reset-settings-btn">
                        <i class="dashicons dashicons-admin-tools"></i>
                        Reset to Defaults
                    </button>
                </div>
            </div>

            <div class="cgap-card">
                <h2><i class="dashicons dashicons-info"></i> Usage Information</h2>
                
                <div class="cgap-usage-info">
                    <div class="usage-item">
                        <span class="usage-label">Current Plan:</span>
                        <span class="usage-value"><?php echo ($settings['license_status'] ?? 'inactive') === 'active' ? 'Premium' : 'Free'; ?></span>
                    </div>
                    
                    <div class="usage-item">
                        <span class="usage-label">Posts This Week:</span>
                        <span class="usage-value"><?php echo $settings['posts_this_week'] ?? 0; ?></span>
                    </div>
                    
                    <div class="usage-item">
                        <span class="usage-label">Last Post Date:</span>
                        <span class="usage-value"><?php echo $settings['last_post_date'] ? date('Y-m-d H:i', strtotime($settings['last_post_date'])) : 'Never'; ?></span>
                    </div>
                    
                    <?php if (($settings['license_status'] ?? 'inactive') !== 'active'): ?>
                    <div class="usage-item">
                        <span class="usage-label">Free Limit:</span>
                        <span class="usage-value">1 post per week</span>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Test Connection Modal -->
<div id="test-connection-modal" class="cgap-modal">
    <div class="cgap-modal-content">
        <div class="cgap-modal-header">
            <h2><i class="dashicons dashicons-admin-tools"></i> Test AI Connection</h2>
            <button type="button" class="cgap-modal-close">&times;</button>
        </div>
        <div class="cgap-modal-body">
            <div class="cgap-form-group">
                <label for="test-api-key">API Key for Testing</label>
                <input type="password" id="test-api-key" placeholder="Enter API key to test">
            </div>
            <div class="cgap-form-group">
                <label for="test-model">Model to Test</label>
                <select id="test-model">
                    <option value="gpt-3.5-turbo">GPT-3.5 Turbo</option>
                    <option value="gpt-4">GPT-4</option>
                    <option value="gpt-4-turbo">GPT-4 Turbo</option>
                </select>
            </div>
        </div>
        <div class="cgap-modal-footer">
            <button type="button" class="cgap-btn cgap-btn-secondary" id="cancel-test">Cancel</button>
            <button type="button" class="cgap-btn cgap-btn-primary" id="confirm-test">
                <i class="dashicons dashicons-admin-tools"></i>
                Test Connection
            </button>
        </div>
    </div>
</div>
