<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap cgap-posts">
    <div class="cgap-header">
        <h1><i class="dashicons dashicons-admin-post"></i> Generated Posts</h1>
        <p class="cgap-subtitle">View and manage all AI-generated posts</p>
    </div>

    <div class="cgap-posts-container">
        <div class="cgap-posts-header">
            <div class="cgap-posts-stats">
                <span class="stat-item">
                    <i class="dashicons dashicons-admin-post"></i>
                    <?php echo $total_items; ?> total posts
                </span>
                <span class="stat-item">
                    <i class="dashicons dashicons-calendar-alt"></i>
                    <?php echo $wpdb->get_var("SELECT COUNT(*) FROM $table_name WHERE DATE(generation_date) = CURDATE()"); ?> today
                </span>
                <span class="stat-item">
                    <i class="dashicons dashicons-chart-line"></i>
                    <?php echo $wpdb->get_var("SELECT COUNT(*) FROM $table_name WHERE DATE(generation_date) >= DATE_SUB(NOW(), INTERVAL 7 DAY)"); ?> this week
                </span>
            </div>
            
            <div class="cgap-posts-actions">
                <button type="button" class="cgap-btn cgap-btn-primary" id="generate-new-post-btn">
                    <i class="dashicons dashicons-plus"></i>
                    Generate New Post
                </button>
                
                <button type="button" class="cgap-btn cgap-btn-secondary" id="export-posts-btn">
                    <i class="dashicons dashicons-download"></i>
                    Export Posts
                </button>
            </div>
        </div>

        <?php if ($total_items > 0): ?>
        <div class="cgap-posts-table">
            <table class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th class="column-title">Post Title</th>
                        <th class="column-keywords">Keywords</th>
                        <th class="column-status">Status</th>
                        <th class="column-date">Generated</th>
                        <th class="column-image">Image</th>
                        <th class="column-actions">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($posts as $post): ?>
                    <?php 
                        $post_title = get_the_title($post->post_id);
                        $post_status = get_post_status($post->post_id);
                        $post_url = get_permalink($post->post_id);
                        $edit_url = get_edit_post_link($post->post_id);
                    ?>
                    <tr>
                        <td class="column-title">
                            <div class="post-title-cell">
                                <strong><?php echo esc_html($post_title); ?></strong>
                                <div class="post-meta">
                                    <span class="post-id">ID: <?php echo $post->post_id; ?></span>
                                    <span class="post-status status-<?php echo $post_status; ?>">
                                        <?php echo ucfirst($post_status); ?>
                                    </span>
                                </div>
                            </div>
                        </td>
                        
                        <td class="column-keywords">
                            <div class="keywords-cell">
                                <?php 
                                $keywords = explode(',', $post->keywords);
                                foreach (array_slice($keywords, 0, 3) as $keyword):
                                ?>
                                <span class="keyword-tag"><?php echo esc_html(trim($keyword)); ?></span>
                                <?php endforeach; ?>
                                <?php if (count($keywords) > 3): ?>
                                <span class="keyword-more">+<?php echo count($keywords) - 3; ?> more</span>
                                <?php endif; ?>
                            </div>
                        </td>
                        
                        <td class="column-status">
                            <span class="status-badge status-<?php echo $post_status; ?>">
                                <?php echo ucfirst($post_status); ?>
                            </span>
                        </td>
                        
                        <td class="column-date">
                            <div class="date-cell">
                                <div class="date-main">
                                    <?php echo date('M j, Y', strtotime($post->generation_date)); ?>
                                </div>
                                <div class="date-time">
                                    <?php echo date('g:i A', strtotime($post->generation_date)); ?>
                                </div>
                            </div>
                        </td>
                        
                        <td class="column-image">
                            <?php if (!empty($post->image_url)): ?>
                            <div class="image-cell">
                                <img src="<?php echo esc_url($post->image_url); ?>" alt="Generated image" class="post-thumbnail">
                                <span class="image-status">Generated</span>
                            </div>
                            <?php else: ?>
                            <div class="image-cell no-image">
                                <i class="dashicons dashicons-format-image"></i>
                                <span class="image-status">No image</span>
                            </div>
                            <?php endif; ?>
                        </td>
                        
                        <td class="column-actions">
                            <div class="actions-cell">
                                <a href="<?php echo $edit_url; ?>" class="cgap-link" target="_blank" title="Edit Post">
                                    <i class="dashicons dashicons-edit"></i>
                                </a>
                                
                                <a href="<?php echo $post_url; ?>" class="cgap-link" target="_blank" title="View Post">
                                    <i class="dashicons dashicons-external"></i>
                                </a>
                                
                                <button type="button" class="cgap-link regenerate-btn" data-post-id="<?php echo $post->post_id; ?>" title="Regenerate Post">
                                    <i class="dashicons dashicons-update"></i>
                                </button>
                                
                                <button type="button" class="cgap-link delete-btn" data-post-id="<?php echo $post->post_id; ?>" title="Delete Post">
                                    <i class="dashicons dashicons-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <?php if ($total_pages > 1): ?>
        <div class="cgap-pagination">
            <div class="pagination-info">
                Showing <?php echo ($offset + 1); ?> to <?php echo min($offset + $per_page, $total_items); ?> of <?php echo $total_items; ?> posts
            </div>
            
            <div class="pagination-links">
                <?php if ($page > 1): ?>
                <a href="?page=auto-poster-posts&paged=<?php echo ($page - 1); ?>" class="cgap-link">
                    <i class="dashicons dashicons-arrow-left-alt2"></i>
                    Previous
                </a>
                <?php endif; ?>
                
                <?php
                $start_page = max(1, $page - 2);
                $end_page = min($total_pages, $page + 2);
                
                for ($i = $start_page; $i <= $end_page; $i++):
                ?>
                <a href="?page=auto-poster-posts&paged=<?php echo $i; ?>" 
                   class="cgap-link <?php echo $i === $page ? 'current' : ''; ?>">
                    <?php echo $i; ?>
                </a>
                <?php endfor; ?>
                
                <?php if ($page < $total_pages): ?>
                <a href="?page=auto-poster-posts&paged=<?php echo ($page + 1); ?>" class="cgap-link">
                    Next
                    <i class="dashicons dashicons-arrow-right-alt2"></i>
                </a>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>

        <?php else: ?>
        <div class="cgap-no-posts">
            <div class="no-posts-content">
                <i class="dashicons dashicons-admin-post"></i>
                <h3>No Generated Posts Yet</h3>
                <p>Start generating posts to see them appear here.</p>
                <button type="button" class="cgap-btn cgap-btn-primary" id="generate-first-post-btn">
                    <i class="dashicons dashicons-plus"></i>
                    Generate Your First Post
                </button>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Generate Post Modal -->
<div id="generate-post-modal" class="cgap-modal">
    <div class="cgap-modal-content">
        <div class="cgap-modal-header">
            <h2><i class="dashicons dashicons-plus"></i> Generate New Post</h2>
            <button type="button" class="cgap-modal-close">&times;</button>
        </div>
        <div class="cgap-modal-body">
            <div class="cgap-form-group">
                <label for="post-keywords">Keywords/Topic</label>
                <textarea id="post-keywords" placeholder="Enter keywords or topic for your post (e.g., 'artificial intelligence, machine learning, future of AI')" rows="3"></textarea>
            </div>
            <div class="cgap-form-group">
                <label>
                    <input type="checkbox" id="generate-image-checkbox">
                    Generate featured image (Premium feature)
                </label>
            </div>
        </div>
        <div class="cgap-modal-footer">
            <button type="button" class="cgap-btn cgap-btn-secondary" id="cancel-generate">Cancel</button>
            <button type="button" class="cgap-btn cgap-btn-primary" id="confirm-generate">
                <i class="dashicons dashicons-plus"></i>
                Generate Post
            </button>
        </div>
    </div>
</div>

<!-- Delete Post Modal -->
<div id="delete-post-modal" class="cgap-modal">
    <div class="cgap-modal-content">
        <div class="cgap-modal-header">
            <h2><i class="dashicons dashicons-trash"></i> Delete Post</h2>
            <button type="button" class="cgap-modal-close">&times;</button>
        </div>
        <div class="cgap-modal-body">
            <p>Are you sure you want to delete this post? This action cannot be undone.</p>
            <div class="delete-post-info">
                <strong>Post Title:</strong> <span id="delete-post-title"></span><br>
                <strong>Post ID:</strong> <span id="delete-post-id"></span>
            </div>
        </div>
        <div class="cgap-modal-footer">
            <button type="button" class="cgap-btn cgap-btn-secondary" id="cancel-delete">Cancel</button>
            <button type="button" class="cgap-btn cgap-btn-danger" id="confirm-delete">
                <i class="dashicons dashicons-trash"></i>
                Delete Post
            </button>
        </div>
    </div>
</div>

<!-- Regenerate Post Modal -->
<div id="regenerate-post-modal" class="cgap-modal">
    <div class="cgap-modal-content">
        <div class="cgap-modal-header">
            <h2><i class="dashicons dashicons-update"></i> Regenerate Post</h2>
            <button type="button" class="cgap-modal-close">&times;</button>
        </div>
        <div class="cgap-modal-body">
            <p>This will create a new post with the same keywords. The original post will remain unchanged.</p>
            <div class="regenerate-post-info">
                <strong>Original Keywords:</strong> <span id="regenerate-keywords"></span><br>
                <strong>Original Post ID:</strong> <span id="regenerate-post-id"></span>
            </div>
            <div class="cgap-form-group">
                <label>
                    <input type="checkbox" id="regenerate-image-checkbox">
                    Generate new featured image (Premium feature)
                </label>
            </div>
        </div>
        <div class="cgap-modal-footer">
            <button type="button" class="cgap-btn cgap-btn-secondary" id="cancel-regenerate">Cancel</button>
            <button type="button" class="cgap-btn cgap-btn-primary" id="confirm-regenerate">
                <i class="dashicons dashicons-update"></i>
                Regenerate Post
            </button>
        </div>
    </div>
</div>

