<?php
if (!defined('ABSPATH')) {
    exit;
}

$knowledge_base = get_option('cgap_knowledge_base', '');
$character_count = strlen($knowledge_base);
$max_characters = $this->get_character_limit();
$usage_percentage = ($character_count / $max_characters) * 100;
?>

<div class="wrap cgap-knowledge">
    <div class="cgap-header">
        <h1><i class="dashicons dashicons-admin-generic"></i> Knowledge Base Management</h1>
        <p class="cgap-subtitle">Upload your knowledge base to improve AI-generated content relevance</p>
    </div>

    <div class="cgap-knowledge-container">
        <div class="cgap-left-panel">
            <div class="cgap-card">
                <h2><i class="dashicons dashicons-upload"></i> Upload Knowledge Base</h2>
                
                <div class="cgap-form-group">
                    <label for="knowledge-text">Knowledge Base Content</label>
                    <textarea id="knowledge-text" rows="15" placeholder="Enter your knowledge base content here. This information will be used by the AI to generate more relevant and accurate posts based on your expertise and domain knowledge.

Examples of what to include:
- Your company's mission and values
- Industry-specific terminology and concepts
- Key products or services you offer
- Target audience information
- Common questions and answers
- Industry trends and insights
- Your unique perspective or approach

The AI will use this information to create posts that align with your brand and expertise."><?php echo esc_textarea($knowledge_base); ?></textarea>
                </div>
                
                <div class="cgap-char-count">
                    <div class="char-count-bar">
                        <div class="char-count-fill" style="width: <?php echo min(100, $usage_percentage); ?>%"></div>
                    </div>
                    <div class="char-count-text">
                        <span id="char-count"><?php echo number_format($character_count); ?></span> / <?php echo number_format($max_characters); ?> characters used
                        <span class="char-percentage">(<?php echo round($usage_percentage, 1); ?>%)</span>
                    </div>
                </div>
                
                <div class="cgap-form-actions">
                    <button type="button" class="cgap-btn cgap-btn-primary" id="save-knowledge-btn">
                        <i class="dashicons dashicons-yes"></i>
                        Save Knowledge Base
                    </button>
                    
                    <button type="button" class="cgap-btn cgap-btn-secondary" id="clear-knowledge-btn">
                        <i class="dashicons dashicons-trash"></i>
                        Clear Knowledge Base
                    </button>
                </div>
            </div>

            <div class="cgap-card">
                <h2><i class="dashicons dashicons-admin-generic"></i> Knowledge Base Tips</h2>
                
                <div class="cgap-tips">
                    <div class="tip-item">
                        <h4><i class="dashicons dashicons-lightbulb"></i> What to Include</h4>
                        <ul>
                            <li><strong>Company Information:</strong> Mission, values, products, services</li>
                            <li><strong>Industry Knowledge:</strong> Terminology, trends, best practices</li>
                            <li><strong>Target Audience:</strong> Demographics, pain points, interests</li>
                            <li><strong>Expertise Areas:</strong> Your unique insights and experience</li>
                            <li><strong>Content Style:</strong> Tone, voice, writing preferences</li>
                        </ul>
                    </div>
                    
                    <div class="tip-item">
                        <h4><i class="dashicons dashicons-admin-tools"></i> Best Practices</h4>
                        <ul>
                            <li>Be specific and detailed in your descriptions</li>
                            <li>Include relevant keywords and phrases</li>
                            <li>Update regularly as your business evolves</li>
                            <li>Focus on quality over quantity</li>
                            <li>Include examples and case studies</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <div class="cgap-right-panel">
            <div class="cgap-card">
                <h2><i class="dashicons dashicons-chart-area"></i> Usage Statistics</h2>
                
                <div class="cgap-usage-stats">
                    <div class="stat-item">
                        <div class="stat-icon">
                            <i class="dashicons dashicons-admin-generic"></i>
                        </div>
                        <div class="stat-content">
                            <h3><?php echo number_format($character_count); ?></h3>
                            <p>Characters Used</p>
                        </div>
                    </div>
                    
                    <div class="stat-item">
                        <div class="stat-icon">
                            <i class="dashicons dashicons-chart-line"></i>
                        </div>
                        <div class="stat-content">
                            <h3><?php echo round($usage_percentage, 1); ?>%</h3>
                            <p>Storage Used</p>
                        </div>
                    </div>
                    
                    <div class="stat-item">
                        <div class="stat-icon">
                            <i class="dashicons dashicons-admin-users"></i>
                        </div>
                        <div class="stat-content">
                            <h3><?php echo $this->is_license_active() ? 'Unlimited' : '5,000'; ?></h3>
                            <p>Character Limit</p>
                        </div>
                    </div>
                </div>
                
                <?php if (!$this->is_license_active()): ?>
                <div class="cgap-upgrade-notice">
                    <h3><i class="dashicons dashicons-star-filled"></i> Upgrade to Premium</h3>
                    <p>Get unlimited knowledge base storage for better AI content generation.</p>
                    <button type="button" class="cgap-btn cgap-btn-primary" id="upgrade-knowledge-btn">
                        Upgrade Now
                    </button>
                </div>
                <?php endif; ?>
            </div>

            <div class="cgap-card">
                <h2><i class="dashicons dashicons-admin-generic"></i> Knowledge Base Preview</h2>
                
                <div class="cgap-knowledge-preview">
                    <?php if (!empty($knowledge_base)): ?>
                        <div class="preview-content">
                            <h4>Current Knowledge Base Content:</h4>
                            <div class="preview-text">
                                <?php echo nl2br(esc_html(substr($knowledge_base, 0, 500))); ?>
                                <?php if (strlen($knowledge_base) > 500): ?>
                                    <span class="preview-more">...</span>
                                <?php endif; ?>
                            </div>
                            <div class="preview-stats">
                                <span class="preview-words"><?php echo str_word_count($knowledge_base); ?> words</span>
                                <span class="preview-lines"><?php echo substr_count($knowledge_base, "\n") + 1; ?> lines</span>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="no-knowledge">
                            <i class="dashicons dashicons-admin-generic"></i>
                            <p>No knowledge base content uploaded yet.</p>
                            <p>Upload your knowledge base to improve AI-generated content quality.</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="cgap-card">
                <h2><i class="dashicons dashicons-admin-tools"></i> Quick Actions</h2>
                
                <div class="cgap-quick-actions">
                    <button type="button" class="cgap-btn cgap-btn-secondary" id="export-knowledge-btn">
                        <i class="dashicons dashicons-download"></i>
                        Export Knowledge Base
                    </button>
                    
                    <button type="button" class="cgap-btn cgap-btn-secondary" id="import-knowledge-btn">
                        <i class="dashicons dashicons-upload"></i>
                        Import Knowledge Base
                    </button>
                    
                    <button type="button" class="cgap-btn cgap-btn-secondary" id="test-knowledge-btn">
                        <i class="dashicons dashicons-admin-tools"></i>
                        Test Knowledge Base
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Import Knowledge Modal -->
<div id="import-knowledge-modal" class="cgap-modal">
    <div class="cgap-modal-content">
        <div class="cgap-modal-header">
            <h2><i class="dashicons dashicons-upload"></i> Import Knowledge Base</h2>
            <button type="button" class="cgap-modal-close">&times;</button>
        </div>
        <div class="cgap-modal-body">
            <div class="cgap-form-group">
                <label for="import-file">Select File</label>
                <input type="file" id="import-file" accept=".txt,.md,.doc,.docx">
                <p class="description">Supported formats: TXT, MD, DOC, DOCX (max 1MB)</p>
            </div>
            <div class="cgap-form-group">
                <label>
                    <input type="checkbox" id="replace-existing">
                    Replace existing knowledge base content
                </label>
            </div>
        </div>
        <div class="cgap-modal-footer">
            <button type="button" class="cgap-btn cgap-btn-secondary" id="cancel-import">Cancel</button>
            <button type="button" class="cgap-btn cgap-btn-primary" id="confirm-import">
                <i class="dashicons dashicons-upload"></i>
                Import Knowledge Base
            </button>
        </div>
    </div>
</div>

<!-- Test Knowledge Modal -->
<div id="test-knowledge-modal" class="cgap-modal">
    <div class="cgap-modal-content">
        <div class="cgap-modal-header">
            <h2><i class="dashicons dashicons-admin-tools"></i> Test Knowledge Base</h2>
            <button type="button" class="cgap-modal-close">&times;</button>
        </div>
        <div class="cgap-modal-body">
            <div class="cgap-form-group">
                <label for="test-keywords">Test Keywords</label>
                <input type="text" id="test-keywords" placeholder="Enter keywords to test knowledge base integration">
            </div>
            <div class="cgap-form-group">
                <label for="test-prompt">Custom Prompt (Optional)</label>
                <textarea id="test-prompt" rows="3" placeholder="Enter a custom prompt to test how the AI uses your knowledge base..."></textarea>
            </div>
        </div>
        <div class="cgap-modal-footer">
            <button type="button" class="cgap-btn cgap-btn-secondary" id="cancel-test-knowledge">Cancel</button>
            <button type="button" class="cgap-btn cgap-btn-primary" id="confirm-test-knowledge">
                <i class="dashicons dashicons-admin-tools"></i>
                Test Knowledge Base
            </button>
        </div>
    </div>
</div>

