<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap cgap-dashboard">
    <div class="cgap-header">
        <h1><i class="dashicons dashicons-admin-post"></i> Auto Poster AI Dashboard</h1>
        <p class="cgap-subtitle">AI-powered automatic content generation and posting</p>
    </div>

    <div class="cgap-stats-grid">
        <div class="cgap-stat-card">
            <div class="stat-icon">
                <i class="dashicons dashicons-admin-post"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}cgap_auto_posts"); ?></h3>
                <p>Total Generated Posts</p>
            </div>
        </div>

        <div class="cgap-stat-card">
            <div class="stat-icon">
                <i class="dashicons dashicons-calendar-alt"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo $settings['posts_this_week'] ?? 0; ?></h3>
                <p>Posts This Week</p>
            </div>
        </div>

        <div class="cgap-stat-card">
            <div class="stat-icon">
                <i class="dashicons dashicons-admin-users"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo $is_license_active ? 'Premium' : 'Free'; ?></h3>
                <p>License Status</p>
            </div>
        </div>

        <div class="cgap-stat-card">
            <div class="stat-icon">
                <i class="dashicons dashicons-chart-line"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo round($usage_percentage, 1); ?>%</h3>
                <p>Knowledge Base Usage</p>
            </div>
        </div>
    </div>

    <div class="cgap-main-content">
        <div class="cgap-left-panel">
            <div class="cgap-card">
                <h2><i class="dashicons dashicons-admin-generic"></i> Quick Actions</h2>
                
                <div class="cgap-quick-actions">
                    <button type="button" class="cgap-btn cgap-btn-primary" id="generate-post-btn">
                        <i class="dashicons dashicons-plus"></i>
                        Generate New Post
                    </button>
                    
                    <button type="button" class="cgap-btn cgap-btn-secondary" id="generate-image-btn">
                        <i class="dashicons dashicons-format-image"></i>
                        Generate Image
                    </button>
                    
                    <button type="button" class="cgap-btn cgap-btn-secondary" id="upload-knowledge-btn">
                        <i class="dashicons dashicons-upload"></i>
                        Upload Knowledge
                    </button>
                </div>
            </div>

            <div class="cgap-card">
                <h2><i class="dashicons dashicons-admin-settings"></i> Current Settings</h2>
                
                <div class="cgap-settings-summary">
                    <div class="setting-item">
                        <span class="setting-label">Auto Posting:</span>
                        <span class="setting-value <?php echo $settings['is_enabled'] ? 'enabled' : 'disabled'; ?>">
                            <?php echo $settings['is_enabled'] ? 'Enabled' : 'Disabled'; ?>
                        </span>
                    </div>
                    
                    <div class="setting-item">
                        <span class="setting-label">Frequency:</span>
                        <span class="setting-value"><?php echo ucfirst($settings['post_frequency'] ?? 'weekly'); ?></span>
                    </div>
                    
                    <div class="setting-item">
                        <span class="setting-label">Post Status:</span>
                        <span class="setting-value"><?php echo ucfirst($settings['post_status'] ?? 'draft'); ?></span>
                    </div>
                    
                    <div class="setting-item">
                        <span class="setting-label">Image Generation:</span>
                        <span class="setting-value <?php echo $settings['generate_images'] ? 'enabled' : 'disabled'; ?>">
                            <?php echo $settings['generate_images'] ? 'Enabled' : 'Disabled'; ?>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <div class="cgap-right-panel">
            <div class="cgap-card">
                <h2><i class="dashicons dashicons-chart-area"></i> Usage Statistics</h2>
                
                <div class="cgap-usage-chart">
                    <div class="usage-bar">
                        <div class="usage-fill" style="width: <?php echo min(100, $usage_percentage); ?>%"></div>
                    </div>
                    <div class="usage-text">
                        <?php echo number_format($character_count); ?> / <?php echo number_format($max_characters); ?> characters used
                    </div>
                </div>
                
                <?php if (!$is_license_active): ?>
                <div class="cgap-upgrade-notice">
                    <h3><i class="dashicons dashicons-star-filled"></i> Upgrade to Premium</h3>
                    <p>Get unlimited knowledge base storage, unlimited posts, and AI image generation.</p>
                    <button type="button" class="cgap-btn cgap-btn-primary" id="upgrade-btn">
                        Upgrade Now
                    </button>
                </div>
                <?php endif; ?>
            </div>

            <div class="cgap-card">
                <h2><i class="dashicons dashicons-clock"></i> Recent Activity</h2>
                
                <div class="cgap-recent-activity">
                    <?php
                    $recent_posts = $wpdb->get_results("
                        SELECT * FROM {$wpdb->prefix}cgap_auto_posts 
                        ORDER BY generation_date DESC 
                        LIMIT 5
                    ");
                    
                    if ($recent_posts):
                        foreach ($recent_posts as $post):
                            $post_title = get_the_title($post->post_id);
                    ?>
                    <div class="activity-item">
                        <div class="activity-icon">
                            <i class="dashicons dashicons-admin-post"></i>
                        </div>
                        <div class="activity-content">
                            <div class="activity-title"><?php echo esc_html($post_title); ?></div>
                            <div class="activity-meta">
                                <?php echo human_time_diff(strtotime($post->generation_date), current_time('timestamp')); ?> ago
                            </div>
                        </div>
                        <div class="activity-actions">
                            <a href="<?php echo get_edit_post_link($post->post_id); ?>" class="cgap-link" target="_blank">
                                <i class="dashicons dashicons-edit"></i>
                            </a>
                            <a href="<?php echo get_permalink($post->post_id); ?>" class="cgap-link" target="_blank">
                                <i class="dashicons dashicons-external"></i>
                            </a>
                        </div>
                    </div>
                    <?php 
                        endforeach;
                    else:
                    ?>
                    <div class="no-activity">
                        <i class="dashicons dashicons-admin-post"></i>
                        <p>No posts generated yet. Start by generating your first post!</p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Generate Post Modal -->
<div id="generate-post-modal" class="cgap-modal">
    <div class="cgap-modal-content">
        <div class="cgap-modal-header">
            <h2><i class="dashicons dashicons-plus"></i> Generate New Post</h2>
            <button type="button" class="cgap-modal-close">&times;</button>
        </div>
        <div class="cgap-modal-body">
            <div class="cgap-form-group">
                <label for="post-keywords">Keywords/Topic</label>
                <textarea id="post-keywords" placeholder="Enter keywords or topic for your post (e.g., 'artificial intelligence, machine learning, future of AI')" rows="3"></textarea>
            </div>
            <div class="cgap-form-group">
                <label>
                    <input type="checkbox" id="generate-image-checkbox">
                    Generate featured image (Premium feature)
                </label>
            </div>
        </div>
        <div class="cgap-modal-footer">
            <button type="button" class="cgap-btn cgap-btn-secondary" id="cancel-generate">Cancel</button>
            <button type="button" class="cgap-btn cgap-btn-primary" id="confirm-generate">
                <i class="dashicons dashicons-plus"></i>
                Generate Post
            </button>
        </div>
    </div>
</div>

<!-- Generate Image Modal -->
<div id="generate-image-modal" class="cgap-modal">
    <div class="cgap-modal-content">
        <div class="cgap-modal-header">
            <h2><i class="dashicons dashicons-format-image"></i> Generate AI Image</h2>
            <button type="button" class="cgap-modal-close">&times;</button>
        </div>
        <div class="cgap-modal-body">
            <div class="cgap-form-group">
                <label for="image-prompt">Image Description</label>
                <textarea id="image-prompt" placeholder="Describe the image you want to generate (e.g., 'A modern office with people working on computers')" rows="3"></textarea>
            </div>
            <div class="cgap-form-group">
                <label for="image-style">Style</label>
                <select id="image-style">
                    <option value="realistic">Realistic</option>
                    <option value="artistic">Artistic</option>
                    <option value="cartoon">Cartoon</option>
                    <option value="abstract">Abstract</option>
                </select>
            </div>
        </div>
        <div class="cgap-modal-footer">
            <button type="button" class="cgap-btn cgap-btn-secondary" id="cancel-image">Cancel</button>
            <button type="button" class="cgap-btn cgap-btn-primary" id="confirm-image">
                <i class="dashicons dashicons-format-image"></i>
                Generate Image
            </button>
        </div>
    </div>
</div>

<!-- Upload Knowledge Modal -->
<div id="upload-knowledge-modal" class="cgap-modal">
    <div class="cgap-modal-content">
        <div class="cgap-modal-header">
            <h2><i class="dashicons dashicons-upload"></i> Upload Knowledge Base</h2>
            <button type="button" class="cgap-modal-close">&times;</button>
        </div>
        <div class="cgap-modal-body">
            <div class="cgap-form-group">
                <label for="knowledge-text">Knowledge Base Content</label>
                <textarea id="knowledge-text" placeholder="Enter your knowledge base content that will be used to generate more relevant posts..." rows="8"></textarea>
                <div class="cgap-char-count">
                    <span id="char-count">0</span> characters used
                </div>
            </div>
        </div>
        <div class="cgap-modal-footer">
            <button type="button" class="cgap-btn cgap-btn-secondary" id="cancel-knowledge">Cancel</button>
            <button type="button" class="cgap-btn cgap-btn-primary" id="confirm-knowledge">
                <i class="dashicons dashicons-upload"></i>
                Upload Knowledge
            </button>
        </div>
    </div>
</div>

